----------------------------------------------------------------------------------
-- Company: The University of Oklahoma
-- Engineer: Arne Schwettmann
-- 
-- Create Date:    18:01:58 03/01/2010 
-- Design Name: 
-- Module Name:    segmentDisplay - Behavioral 
-- Project Name:   Shaffer Lab Lockbox
-- Target Devices: Digilent Nexys2 1200k Spartan3 based evaluation board
-- Tool versions: 
-- Description: 
--    please see the top level source file "lockbox.vhdl" for release info 
--
-- Dependencies: 
--
-- Revision: 
--    1.0 public release (August 2011)
--
-- Additional Comments: 
--
----------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

--  Uncomment the following lines to use the declarations that are
--  provided for instantiating Xilinx primitive components.
--library UNISIM;
--use UNISIM.VComponents.all;

-- controller for the seven segment display on Digilent Nexys2 board
-- displays 12 bit number input as "numberToDisplay" as a decimal 
-- 4 digit number between 0 and 4095 

entity segmentDisplay is
    Port (
      clkMain  : in std_logic;
      seg      : out std_logic_vector(6 downto 0);
      an       : out std_logic_vector(3 downto 0);
      dp       : out std_logic;
      numberToDisplay   : in std_logic_vector(11 downto 0)
   );
end segmentDisplay;

architecture Behavioral of segmentDisplay is

------------------------------------------------------------------------
-- Component Declarations
------------------------------------------------------------------------

------------------------------------------------------------------------
-- Local Type Declarations
------------------------------------------------------------------------

------------------------------------------------------------------------
--  Constant Declarations
------------------------------------------------------------------------

   -- these are the segment display digit definitions
   constant segDigit0 : std_logic_vector(6 downto 0) := "1000000";
   constant segDigit1 : std_logic_vector(6 downto 0) := "1111001";
   constant segDigit2 : std_logic_vector(6 downto 0) := "0100100";
   constant segDigit3 : std_logic_vector(6 downto 0) := "0110000";
   constant segDigit4 : std_logic_vector(6 downto 0) := "0011001";
   constant segDigit5 : std_logic_vector(6 downto 0) := "0010010";
   constant segDigit6 : std_logic_vector(6 downto 0) := "0000010";
   constant segDigit7 : std_logic_vector(6 downto 0) := "1111000";
   constant segDigit8 : std_logic_vector(6 downto 0) := "0000000";
   constant segDigit9 : std_logic_vector(6 downto 0) := "0011000";
   
   -- these variables are used to generate the right signals for the 
   -- segment display
   
   signal currentNumber : std_logic_vector(3 downto 0);
   signal currentDigit  : std_logic_vector(1 downto 0);
   signal bcdNumber     : std_logic_vector(15 downto 0);

------------------------------------------------------------------------
-- Signal Declarations
------------------------------------------------------------------------

   -- counter used to flip between digits fast enough so it doesnt flicker
   -- too much (60Hz or faster)
   signal   cntr        : std_logic_vector(23 downto 0);


------------------------------------------------------------------------
-- Module Implementation
------------------------------------------------------------------------

begin


   currentDigit <= cntr(10 downto 9);
      
   
   -- this is a binary to binary encoded decimal (bcd) converter using shift and add 3 algorithm
      
   process(numberToDisplay)
      variable z: STD_LOGIC_VECTOR (27 downto 0);
      begin
         for i in 0 to 27 loop
            z(i) := '0';
         end loop;
         z(11 downto 0) := numberToDisplay(11 downto 0);
         for i in 0 to 11 loop
            if z(15 downto 12) > 4 then
               z(15 downto 12) := z(15 downto 12) + 3;
            end if;
            if z(19 downto 16) > 4 then
               z(19 downto 16) := z(19 downto 16) + 3;
            end if;
            if z(23 downto 20) > 4 then
               z(23 downto 20) := z(23 downto 20) + 3;
            end if;
            if z(27 downto 24) > 4 then
               z(27 downto 24) := z(27 downto 24) + 3;
            end if;
               z(27 downto 1) := z(26 downto 0);
         end loop;
         bcdNumber <= z(27 downto 12);
      end process;
   
   currentNumber <=  bcdNumber(15 downto 12) when currentDigit=3 else
                  bcdNumber(11 downto 8) when currentDigit=2 else
                  bcdNumber(7 downto 4) when currentDigit=1 else
                  bcdNumber(3 downto 0) when currentDigit=0 else
                  "0000";
   
   an <= "1110" when currentDigit=0 else
      "1101" when currentDigit=1 else
      "1011" when currentDigit=2 else
      "0111" when currentDigit=3 else
      "1111";

   seg <= segDigit0 when currentNumber = 0 else
            segDigit1 when currentNumber = 1 else
            segDigit2 when currentNumber = 2 else
            segDigit3 when currentNumber = 3 else
            segDigit4 when currentNumber = 4 else
            segDigit5 when currentNumber = 5 else
            segDigit6 when currentNumber = 6 else
            segDigit7 when currentNumber = 7 else
            segDigit8 when currentNumber = 8 else
            segDigit9 when currentNumber = 9 else
            segDigit0;
   
   dp <= cntr(23) when currentDigit=0 else '1';          
   
   process (clkMain)
      begin
         if clkMain = '1' and clkMain'Event then
            cntr <= cntr + 1;
         end if;
      end process;

end Behavioral;
