----------------------------------------------------------------------------------
-- Company: The University of Oklahoma
-- Engineer: Arne Schwettmann
-- 
-- Create Date:    18:01:58 03/01/2010 
-- Design Name: 
-- Module Name:    triangleGenerator16bit - Behavioral 
-- Project Name:   Shaffer Lab Lockbox
-- Target Devices: Digilent Nexys2 1200k Spartan3 based evaluation board
-- Tool versions: 
-- Description: 
--    please see the top level source file "lockbox.vhdl" for release info 
--
-- Dependencies: 
--
-- Revision: 
--    1.0 public release (August 2011)
--
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity triangleGenerator16bit is
   port (
      clk      : in std_logic;
      output   : out signed(15 downto 0);
      deltaY   : in unsigned(15 downto 0); 
      deltaX   : in unsigned(15 downto 0); 
      amplitude: in unsigned(15 downto 0); 
      constantoffset   : in signed(15 downto 0);
      bypass   : in std_logic;
      reset    : in std_logic
   );
end triangleGenerator16bit;

architecture Behavioral of triangleGenerator16bit is

signal currentOutput       : signed(23 downto 0);

begin

-- Output a triangle waveform

   testWaveForm: process (clk, reset)
   variable cntTriangleWave  : signed(23 downto 0);
   variable max              : signed(23 downto 0);
   variable min              : signed(23 downto 0);
   variable triangleWaveSlopeSign  : std_logic; -- sign of slope
   variable stepsTaken       : unsigned(15 downto 0);
   variable unclamped        : signed(23 downto 0);
   
   begin
      if reset='1' then
               currentOutput <= b"0000_0000_0000_0000_0000_0000";
               stepsTaken := b"0000_0000_0000_0000";
               cntTriangleWave := b"0000_0000_0000_0000_0000_0000";
               triangleWaveSlopeSign := '1';
      else
         if rising_edge(clk) then
               max := conv_signed(amplitude,24) - conv_signed(deltaY,24);
               min := conv_signed(deltaY,24) - conv_signed(amplitude,24);
               --if cntTriangleWave >= conv_signed(32767,24) then
               if cntTriangleWave >= max then
                  triangleWaveSlopeSign := '0';
                  cntTriangleWave := max;
               elsif cntTriangleWave <= min then
                  triangleWaveSlopeSign := '1';
                  cntTriangleWave := min;
               end if;
               if stepsTaken = deltaX then
                  if triangleWaveSlopeSign='1' then
                        cntTriangleWave := cntTriangleWave + conv_signed(deltaY,24);
                  else 
                        cntTriangleWave := cntTriangleWave - conv_signed(deltaY,24);
                  end if;
                  stepsTaken := conv_unsigned(1, 16);
               else
                  stepsTaken := stepsTaken + conv_unsigned(1, 16);
               end if;
               
               unclamped := cntTriangleWave + constantOffset;
               
               if unclamped > conv_signed(32767, 24) then
                  currentOutput <= conv_signed(32767, 24);
               elsif unclamped < conv_signed(-32768, 24) then
                  currentOutput <= conv_signed(-32768, 24);
               else
                  currentOutput <= unclamped;
               end if;
         end if;
      end if;   
   end process;
   
   output <= b"0000_0000_0000_0000" when bypass = '1' else
      currentOutput(15 downto 0);
            
end Behavioral;