----------------------------------------------------------------------------------
-- Company: The University of Oklahoma
-- Engineer: Arne Schwettmann
-- 
-- Create Date:    18:01:58 03/01/2010 
-- Design Name: 
-- Module Name:    turn 16bit number into negative - Behavioral 
-- Project Name:   Shaffer Lab Lockbox
-- Target Devices: Digilent Nexys2 1200k Spartan3 based evaluation board
-- Tool versions: 
-- Description: 
--    please see the top level source file "lockbox.vhdl" for release info 
--
-- Dependencies: 
--
-- Revision: 
-- Revision 0.01 - File Created
-- Additional Comments: 
--
----------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity twosComplement16bit is
   port (
      clk      : in std_logic;
      input    : in signed(15 downto 0);
      output   : out signed(15 downto 0);
      bypass   : in std_logic;
      reset    : in std_logic
   );
end twosComplement16bit;

architecture Behavioral of twosComplement16bit is

signal currentOutput : signed(15 downto 0);

begin

   twosComplement: process (clk, reset, bypass)
   
   begin
      if reset='1' then
         currentOutput<=conv_signed(0,16);
      elsif bypass='0' then      
         if rising_edge(clk) then
            if input=conv_signed(-32768,16) then
               currentOutput<=conv_signed(32767,16); 
            else
               currentOutput<=conv_signed(0,16)-input;
            end if;
         end if;
      end if;
   end process;
   
   -- output
   output <= input when bypass = '1' else 
      currentOutput;
       
end Behavioral;