// definitions for LockBoxControlWinMain
// please see the top of LockBoxControlWinMain.cpp for information
// on this program.

//---------------------------------------------------------------------------

#ifndef LockBoxControlWinMainH
#define LockBoxControlWinMainH
//---------------------------------------------------------------------------
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>


#include <windows.h>
#include <stdio.h>

//dpcdemo includes
#include "gendefs.h" /* holds definitions for the DPCDEMO program */

//dpcutil includes
#include "dpcdefs.h"	/* holds error codes and data types for dpcutil	*/
#include "dpcutil.h"	/* holds declaration of DPCUTIL API calls		*/

#include <Menus.hpp>
#include <ExtCtrls.hpp>
#include <Dialogs.hpp>	/* holds declaration of DPCUTIL API calls		*/

//give meaningful names to the registers in the fpga
//PID gains are 24bit wide, and require three 8 bit registers each
  const reg_pIDPiezoPRegister1               = 0;
  const reg_pIDPiezoPRegister2               = 1;
  const reg_pIDPiezoPRegister3               = 2;
  const reg_pIDPiezoIRegister1               = 3;
  const reg_pIDPiezoIRegister2               = 4;
  const reg_pIDPiezoIRegister3               = 5;
  const reg_pIDPiezoDRegister1               = 6;
  const reg_pIDPiezoDRegister2               = 7;
  const reg_pIDPiezoDRegister3               = 8;
  const reg_pIDPiezoGRegister1               = 9;
  const reg_pIDPiezoGRegister2               = 10;
  const reg_pIDPiezoGRegister3               = 11;
  const reg_pIDPiezoSetPointRegister1        = 12;
  const reg_pIDPiezoSetPointRegister2        = 13;
  const reg_pIDCurrentPRegister1             = 14;
  const reg_pIDCurrentPRegister2             = 15;
  const reg_pIDCurrentPRegister3             = 16;
  const reg_pIDCurrentIRegister1             = 17;
  const reg_pIDCurrentIRegister2             = 18;
  const reg_pIDCurrentIRegister3             = 19;
  const reg_pIDCurrentDRegister1             = 20;
  const reg_pIDCurrentDRegister2             = 21;
  const reg_pIDCurrentDRegister3             = 22;
  const reg_pIDCurrentGRegister1             = 23;
  const reg_pIDCurrentGRegister2             = 24;
  const reg_pIDCurrentGRegister3             = 25;
  const reg_pIDCurrentICutOffFreqRegister1   = 26;
  const reg_pIDCurrentICutOffFreqRegister2   = 27;
//  const register28                         = 28;
  const reg_bypasses                         = 29;
  const reg_bypasses2                        = 30;
  const reg_cutOffFreq1Register1             = 31;
  const reg_cutOffFreq1Register2             = 32;
  const reg_cutOffFreq1Register3             = 33;
  const reg_cutOffFreq2Register1             = 34;
  const reg_cutOffFreq2Register2             = 35;
  const reg_cutOffFreq2Register3             = 36;
  const reg_inputOffsetRegister1             = 37;
  const reg_inputOffsetRegister2             = 38;
  const reg_inputGainRegister1               = 39;
  const reg_inputGainRegister2               = 40;
  const reg_scanDeltaYRegister1              = 41;
  const reg_scanDeltaYRegister2              = 42;
  const reg_scanDeltaXRegister1              = 43;
  const reg_scanDeltaXRegister2              = 44;
  const reg_scanOffsetRegister1              = 45;
  const reg_scanOffsetRegister2              = 46;
  const reg_scanAmplitudeRegister1           = 47;
  const reg_scanAmplitudeRegister2           = 48;

//  const nameRegister                      = 47;
//  const nameRegister                      = 48;
//  const nameRegister                      = 49;

//bypasses, various toggle bits
  const reg_lowPass1BypassBit                = 0;
  const reg_highPass1BypassBit               = 1;
  const reg_pIDPiezoBypassBit                = 2;
  const reg_pIDCurrentBypassBit              = 3;
  const reg_testWaveFormEnableBit            = 4;
  const reg_resetBit                         = 5;
  const reg_scanBypassBit                    = 6;
  const reg_lockedBit                        = 7;

//bypasses2, more toggle bits
  const reg_PIDCurrentICutOffBypassBit       = 0;
  const reg_doneWritingBit                   = 1;
  const reg_bypassAllBit                     = 2;
  const reg_pIDCurrentPolarityBit            = 3;
  const reg_scanSetPointBit                  = 4;
  const reg_scanRestartBit                   = 5;

//---------------------------------------------------------------------------
class TForm3 : public TForm
{
__published:	// IDE-managed Components

  TPageControl *PageControl1;
  TMainMenu *MainMenu1;
  TMenuItem *File1;
  TMenuItem *LoadSettings1;
  TMenuItem *SaveConfig1;
  TMenuItem *SaveConfigas1;
  TMenuItem *Exit1;
  TMenuItem *Help1;
  TMenuItem *EnableHints1;
  TRadioGroup *TestWaveformRadioGroup;
  TCheckBox *TestWaveformEnableCheckBox;
  TSaveDialog *SaveDialog1;
  TOpenDialog *OpenDialog1;
  TTabSheet *LockTabSheet;
  TTabSheet *FiltersTabSheet;
  TTabSheet *DebugTabSheet;
  TTabSheet *ScanTabSheet;
  TLabel *InputOffsetLabel;
  TLabel *PIDPiezoPLabel;
  TLabel *PIDPiezoILabel;
  TLabel *PIDPiezoDLabel;
  TLabel *PIDPiezoGainLabel;
  TLabel *SetPointLabel;
  TEdit *InputLowPassCutOffFreqEdit;
  TEdit *InputOffsetEdit;
  TCheckBox *InputLowPassEnableCheckBox;

  TEdit *PIDPiezoGEdit;
  TButton *PIDPiezoGIncreaseButton;
  TButton *PIDPiezoGDecreaseButton;
  TEdit *PIDPiezoPEdit;
  TButton *PIDPiezoPIncreaseButton;
  TButton *PIDPiezoPDecreaseButton;
  TEdit *PIDPiezoIEdit;
  TButton *PIDPiezoIIncreaseButton;
  TButton *PIDPiezoIDecreaseButton;
  TEdit *PIDPiezoDEdit;
  TButton *PIDPiezoDIncreaseButton;
  TButton *PIDPiezoDDecreaseButton;
  TEdit *PIDPiezoSetPointEdit;
  TButton *PIDPiezoSetPointIncreaseButton;
  TButton *PIDPiezoSetPointDecreaseButton;

  TEdit *PIDCurrentGEdit;
  TButton *PIDCurrentGIncreaseButton;
  TButton *PIDCurrentGDecreaseButton;
  TEdit *PIDCurrentPEdit;
  TButton *PIDCurrentPIncreaseButton;
  TButton *PIDCurrentPDecreaseButton;
  TEdit *PIDCurrentIEdit;
  TButton *PIDCurrentIIncreaseButton;
  TButton *PIDCurrentIDecreaseButton;
  TEdit *PIDCurrentDEdit;
  TButton *PIDCurrentDIncreaseButton;
  TButton *PIDCurrentDDecreaseButton;


  TButton *ResetButton;
  TLabel *PIDCurrentPLabel;
  TLabel *PIDCurrentILabel;
  TLabel *PIDCurrentDLabel;
  TLabel *PIDCurrentGainLabel;
  TLabel *PIDPiezoLabel;
  TBevel *PiezoPIDBevel;
  TBevel *PIDCurrentBevel;
  TLabel *PIDCurrentLabel;
  TCheckBox *LockCheckBox;
  TCheckBox *PIDPiezoEnableCheckBox;
  TCheckBox *PIDCurrentEnableCheckBox;
  TLabel *InputLowPassCutOffFreqLabel;
  TBevel *LowPass1Bevel;
  TButton *InputOffsetIncreaseButtton;
  TButton *InputOffsetDecreaseButtton;
  TLabel *InputOffsetAndGainLabel;
  TBevel *InputOffsetAndGainBevel;
  TLabel *InputGainLabel;
  TButton *InputGainIncreaseButton;
  TButton *InputGainDecreaseButton;
  TEdit *InputGainEdit;
  TLabel *InputLowPassLabel;
  TButton *InputLowPassCutOffFreqIncreaseButton;
  TButton *InputLowPassCutOffFreqDecreaseButton;
  TLabel *InputHighPassLabel;
  TEdit *InputHighPassCutOffFreqEdit;
  TButton *InputHighPassCutOffFreqIncreaseButtonn;
  TButton *InputHighPassCutOffFreqDecreaseButton;
  TLabel *InputHighPassCutOffFreqLabel;
  TCheckBox *InputHighPassEnableCheckBox;
  TBevel *InputHighPassBevel;
  TLabel *Label1;
  TLabel *ScanAmplitudeLabel;
  TLabel *ScanFrequencyLabel;
  TBevel *Bevel1;
  TLabel *ScanOffsetLabel;
  TButton *ScanAmplitudeIncreaseButton;
  TButton *ScanAmplitudeDecreaseButton;
  TEdit *ScanAmplitudeEdit;
  TButton *ScanFrequencyIncreaseButton;
  TButton *ScanFrequencyDecreaseButton;
  TEdit *ScanFrequencyEdit;
  TButton *ScanOffsetIncreaseButton;
  TButton *ScanOffsetDecreaseButton;
  TEdit *ScanOffsetEdit;
  TCheckBox *ScanEnableCheckBox;
  TEdit *PIDCurrentICutOffFrequencyEdit;
  TButton *PIDCurrentICutOffFrequencyIncreaseButton;
  TButton *PIDCurrentICutOffFrequencyDecreaseButton;
  TLabel *PIDCurrentICutOffFreqLabel;
  TCheckBox *PIDCurrentICutOffEnableCheckBox;
  TMenuItem *Edit1;
  TMenuItem *SelectDevice1;
  TCheckBox *BypassAllCheckBox;
  TCheckBox *PIDCurrentPolarityCheckBox;
  TCheckBox *ScanSetPointCheckBox;
  TButton *ScanRestartButton;
  void __fastcall InputOffsetEditExit(TObject *Sender);
  void __fastcall InputLowPassCutOffFreqEditExit(TObject *Sender);
  void __fastcall EnableHints1Click(TObject *Sender);
  void __fastcall TestWaveformEnableCheckBoxClick(TObject *Sender);
  void __fastcall TestWaveformRadioGroupClick(TObject *Sender);
  void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
  void __fastcall PIDPiezoGEditExit(TObject *Sender);
  void __fastcall PIDPiezoGIncreaseButtonClick(TObject *Sender);
  void __fastcall PIDPiezoGDecreaseButtonClick(TObject *Sender);
  void __fastcall PIDPiezoPEditExit(TObject *Sender);
  void __fastcall PIDPiezoPIncreaseButtonClick(TObject *Sender);
  void __fastcall PIDPiezoPDecreaseButtonClick(TObject *Sender);
  void __fastcall PIDPiezoIEditExit(TObject *Sender);
  void __fastcall PIDPiezoIIncreaseButtonClick(TObject *Sender);
  void __fastcall PIDPiezoIDecreaseButtonClick(TObject *Sender);
  void __fastcall PIDPiezoDEditExit(TObject *Sender);
  void __fastcall PIDPiezoDIncreaseButtonClick(TObject *Sender);
  void __fastcall PIDPiezoDDecreaseButtonClick(TObject *Sender);
  void __fastcall PIDPiezoSetPointEditExit(TObject *Sender);
  void __fastcall PIDPiezoSetPointIncreaseButtonClick(TObject *Sender);
  void __fastcall PIDPiezoSetPointDecreaseButtonClick(TObject *Sender);

  void __fastcall PIDCurrentGEditExit(TObject *Sender);
  void __fastcall PIDCurrentGIncreaseButtonClick(TObject *Sender);
  void __fastcall PIDCurrentGDecreaseButtonClick(TObject *Sender);
  void __fastcall PIDCurrentPEditExit(TObject *Sender);
  void __fastcall PIDCurrentPIncreaseButtonClick(TObject *Sender);
  void __fastcall PIDCurrentPDecreaseButtonClick(TObject *Sender);
  void __fastcall PIDCurrentIEditExit(TObject *Sender);
  void __fastcall PIDCurrentIIncreaseButtonClick(TObject *Sender);
  void __fastcall PIDCurrentIDecreaseButtonClick(TObject *Sender);
  void __fastcall PIDCurrentDEditExit(TObject *Sender);
  void __fastcall PIDCurrentDIncreaseButtonClick(TObject *Sender);
  void __fastcall PIDCurrentDDecreaseButtonClick(TObject *Sender);

  void __fastcall InputLowPassEnableCheckBoxClick(TObject *Sender);
  void __fastcall ResetButtonClick(TObject *Sender);
  void __fastcall PIDPiezoEnableCheckBoxClick(TObject *Sender);
  void __fastcall PIDCurrentEnableCheckBoxClick(TObject *Sender);
  void __fastcall PIDCurrentPolarityCheckBoxClick(TObject *Sender);
  void __fastcall PIDPiezoGEditKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
  void __fastcall PIDPiezoPEditKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
  void __fastcall PIDPiezoIEditKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
  void __fastcall PIDPiezoDEditKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
  void __fastcall PIDCurrentGEditKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
  void __fastcall PIDCurrentPEditKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
  void __fastcall PIDCurrentIEditKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
  void __fastcall PIDCurrentDEditKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
  void __fastcall PIDPiezoSetPointEditKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
  void __fastcall InputHighPassEnableCheckBoxClick(TObject *Sender);
  void __fastcall ScanEnableCheckBoxClick(TObject *Sender);
  void __fastcall ScanAmplitudeEditExit(TObject *Sender);
  void __fastcall ScanAmplitudeEditKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
  void __fastcall ScanFrequencyEditKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
  void __fastcall ScanFrequencyEditExit(TObject *Sender);
  void __fastcall ScanAmplitudeIncreaseButtonClick(TObject *Sender);
  void __fastcall ScanAmplitudeDecreaseButtonClick(TObject *Sender);
  void __fastcall ScanFrequencyIncreaseButtonClick(TObject *Sender);
  void __fastcall ScanFrequencyDecreaseButtonClick(TObject *Sender);
  void __fastcall ScanOffsetEditKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
  void __fastcall ScanOffsetEditExit(TObject *Sender);
  void __fastcall ScanOffsetIncreaseButtonClick(TObject *Sender);
  void __fastcall ScanOffsetDecreaseButtonClick(TObject *Sender);
  void __fastcall InputGainEditExit(TObject *Sender);
  void __fastcall InputHighPassCutOffFreqEditExit(TObject *Sender);
  void __fastcall InputHighPassCutOffFreqIncreaseButtonClick(TObject *Sender);
  void __fastcall InputHighPassCutOffFreqDecreaseButtonClick(TObject *Sender);
  void __fastcall InputLowPassCutOffFreqDecreaseButtonClick(TObject *Sender);
  void __fastcall InputLowPassCutOffFreqIncreaseButtonClick(TObject *Sender);
  void __fastcall InputOffsetIncreaseButttonClick(TObject *Sender);
  void __fastcall InputOffsetDecreaseButttonClick(TObject *Sender);
  void __fastcall InputGainIncreaseButtonClick(TObject *Sender);
  void __fastcall InputGainDecreaseButtonClick(TObject *Sender);
  void __fastcall InputOffsetEditKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
  void __fastcall InputGainEditKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
  void __fastcall InputLowPassCutOffFreqEditKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
  void __fastcall InputHighPassCutOffFreqEditKeyDown(TObject *Sender, WORD &Key,
          TShiftState Shift);
  void __fastcall LockCheckBoxClick(TObject *Sender);
  void __fastcall PIDCurrentICutOffEnableCheckBoxClick(TObject *Sender);
  void __fastcall PIDCurrentICutOffFrequencyEditExit(TObject *Sender);
  void __fastcall PIDCurrentICutOffFrequencyEditKeyDown(TObject *Sender,
          WORD &Key, TShiftState Shift);
  void __fastcall PIDCurrentICutOffFrequencyIncreaseButtonClick(
          TObject *Sender);
  void __fastcall PIDCurrentICutOffFrequencyDecreaseButtonClick(
          TObject *Sender);
  void __fastcall SelectDevice1Click(TObject *Sender);
  void __fastcall BypassAllCheckBoxClick(TObject *Sender);
  void __fastcall ScanSetPointCheckBoxClick(TObject *Sender);
  void __fastcall ScanRestartButtonClick(TObject *Sender);

private:	// User declarations

  //functions used to communicate with the FPGA
  //taken from DPCUTIL Demo
  char			szDefDvc[cchShortString+1];
  BOOL		FInit();
  void		DoDvcTbl();
  void		DoPutReg(BYTE idReg, BYTE idData);
  void		DoGetReg(BYTE idReg, BYTE &idData);

  //piezo PID
  struct pIDP {
    unsigned int kP;
    unsigned int kI;
    unsigned int kD;
    unsigned int g;
    int setPoint;
    bool bypass;
  };

  //current PID
  struct pIDC {
    unsigned int kP;
    unsigned int kI;
    unsigned int kD;
    unsigned int g;
    int setPoint;
    bool bypass;
    unsigned int iCutOffFreq;
    bool cutOffBypass;
    bool polarity;
  };

  //filter
  struct filter {
    unsigned int cutOffFreq;
    bool bypass;
  };

  //input offset and gain
  struct input {
    int offset;
    int gain;
  };

  //scan waveform
  struct scan {
    bool bypass;
    int amplitude;
    int frequency;
    int offset;
  };

  //test waveform
  struct testWaveform {
    bool enable;
    int nr;
  };

  bool lock;                        //are we in locked state?
  bool bypassAll;                   //are we in bypass all debugging state?
  bool scanSetPoint;                //are we scanning the Setpoint?
  pIDP pIDPiezo;                    //piezo PID module
  pIDC pIDCurrent;                  //current PID module
  filter lowPass1;                  //lowpass filter on input
  filter highPass1;                 //highpass filter on input
  testWaveform testWave;            //unused
  input input1;                     //offset and gain on input
  scan scan1;                       //scan waveform
  AnsiString programDirectory;      //current program directory
  AnsiString defaultConfigFileName; //default config filename

//  void EditWithScrollBarChange(TEdit *edit, TScrollBar *scrollBar); //

  //loads all the parameters from a config file
  void LoadSettings(AnsiString fileName);

  //saves all the parameters to a config file
  void SaveSettings(AnsiString fileName);

  //updates the user interface and FPGA, after config file load
  void UpdateGUIAndFPGA();

  //done sending a >8 bit parameter to FPGA that comprises multiple registers
  void DoneWriting();

  //check routine called after user changes a number in an editable field
  int __fastcall GetEditIntValue(TEdit *edit, int maxValue, int minValue, int oldValue);

  //check value for upper/lower bounds when user clicks an increment/decrement button
  int __fastcall SetEditIntValue(TEdit *edit, int maxValue, int minValue, int newValue);

  //increments a parameter, called on increment button click or cursor up
  void __fastcall IncreaseEditValue(TEdit *edit, int maxValue, int minValue, int oldValue);

  //decrements a parameter, called on decrement button click or cursor down
  void __fastcall DecreaseEditValue(TEdit *edit, int maxValue, int minValue, int oldValue);

  //returns +1 or -1 depending on sign of argument
  int __fastcall Signum(int a);

  public:		// User declarations
  __fastcall TForm3(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern PACKAGE TForm3 *Form3;
//---------------------------------------------------------------------------
#endif
